# This script is part 5 of the pipeline; It:
# 1. imports data after qc filtering, sensor self heating correction, gap filling and error propagation
# 2. generates the output for uploading the data to the repository
# 
# Felix Nieberding
# 2020-08-26


rm(list=ls())
Sys.setenv(TZ='UTC')

library(tidyverse)
library(data.table)

setwd(dir = "~/TransTiP/_NamCo_sync/3_data_qa-qc/Flux data/ESSD_scripts_review/")

# import ------------------------------------------------------------------
# corrected
df_SSH_WLG <- fread("df_WLG_openeddy_SSH.csv", na.strings = c("-9999", "-9999.0")) %>% mutate(DATETIME = as.POSIXct(DATETIME))

df_GF_WLG <- fread("df_WLG_openeddy_SSH_gapfill.csv", na.strings = c("-9999", "-9999.0")) %>% mutate(DATETIME = as.POSIXct(DATETIME))

# uncorrected
df_SSH_ORG <- fread("df_ORG_openeddy_SSH.csv", na.strings = c("-9999", "-9999.0")) %>% mutate(DATETIME = as.POSIXct(DATETIME))

df_GF_ORG <- fread("df_ORG_openeddy_SSH_gapfill.csv", na.strings = c("-9999", "-9999.0")) %>% mutate(DATETIME = as.POSIXct(DATETIME))

# join files
df_WLG <- left_join(df_SSH_WLG, df_GF_WLG, by = "DATETIME")
df_ORG <- left_join(df_SSH_ORG, df_GF_ORG, by = "DATETIME")

df_ORG <- df_ORG %>%
  select(co2_molar_density,
         co2_mole_fraction,
         co2_mixing_ratio,
         h2o_molar_density_Li7500,
         h2o_mole_fraction_Li7500,
         h2o_mixing_ratio_Li7500) %>%
  rename_all(.funs = ~paste(.,"_ORG", sep = ""))


df <- cbind.data.frame(df_WLG, df_ORG)
# export ------------------------------------------------------------------
df_export <- df %>%  
  filter(DATETIME < "2019-09-07 12:00") %>%
  select(1:177, 179:190,
         co2_molar_density_ORG,
         co2_mole_fraction_ORG,
         co2_mixing_ratio_ORG,
         h2o_molar_density_Li7500_ORG,
         h2o_mole_fraction_Li7500_ORG,
         h2o_mixing_ratio_Li7500_ORG,
         h2o_molar_density_Li7500,
         h2o_mole_fraction_Li7500,
         h2o_mixing_ratio_Li7500,
         qc_wind_dir,
         qc_ustar,
         qc_NEE_composite, 
         qc_h2o_composite, 
         qc_co2_molar_density_composite,
         qc_co2_mixing_ratio_composite,
         qc_h2o_molar_density_composite,
         qc_h2o_molar_density_Li7500_composite,
         qc_h2o_mixing_ratio_composite,
         qc_h2o_mixing_ratio_Li7500_composite,
         # starts_with("qc_fetch"),
         F_CO2, HC_Burba, HC_Frank, F_CO2_HC_Burba, F_CO2_HC_Frank,
         starts_with("NEE_"),
         -contains(c("ch4", "none", "LI.7200", "LI.7500", "LI.7700")),
         DATETIME) %>%
  select_if(function(x){!all(is.na(x))}) %>%
  rename(qc_co2_flux_composite = qc_NEE_composite,
         qc_h2o_flux_composite = qc_h2o_composite,
         ustar = u.,
         tstar = T.,
         `z-d/L` = X.z.d..L,
         RH = RH.x,
         Rh = RH.y,
         VPD = VPD.x,
         Rg = Rg.x,
         x_10 = x_10., 
         x_30 = x_30.,
         x_50 = x_50.,
         x_70 = x_70.,
         x_90 = x_90.
  ) %>%
  mutate(date = as.character(as.Date(DATETIME)),
         time = str_sub(as.character(DATETIME), start = 12, end = 16),
         DATETIME = as.character(DATETIME)) %>%
  select(-DATETIME)

fwrite(df_export, "NAMORS_EC_2005-2019_v2.txt", na = "-9999", sep = "\t")
